/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: bcast.c,v 1.26 2006/03/31 19:34:36 karen Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"

#define HELLO_MAGIC 0xcafebabe

#define MAKE_MATCH(a,b) ((uint64_t)(a) << 32 | (b))

static inline void 
return_check( mx_return_t rc, char *str) 
{
  if (rc != MX_SUCCESS) {
    printf( "%s : %s\n", str, mx_strerror(rc));
    exit (1);
  }
}

static inline void 
return_check2( mx_return_t rc, uint32_t result, char *str) 
{
  if (rc != MX_SUCCESS ||
      !result) {
    printf( "%s : %s\n", str, mx_strerror(rc));
    exit (1);
  }
}

int
main(int argc,
     char **argv)
{
  mx_endpoint_addr_t dest[2];
  int sender;
  mx_return_t rc;
  mx_endpoint_t endpoint;
  mx_segment_t seg[2];
  mx_request_t handle;
  mx_status_t stat;
  uint32_t unmaskable;
  uint32_t maskable;
  uint32_t match_mask;
  char buf[80];
  mx_endpoint_addr_t my_address;
  char dest_str[80];
  uint64_t nic_id;
  uint32_t endpoint_id;
  uint32_t filter_val;
  uint32_t result;

  sender = 0;	/* by default, we are not the sender */

  unmaskable = 0x12345678;
  maskable = 0xabcd1234;
  match_mask = 0xffffffff;

  if (argc > 1) {
    sender = 1;
    printf("I am sender\n");
  }

  rc = mx_init();
  return_check (rc, "mx_init");

  rc = mx_open_endpoint(MX_ANY_NIC, 1, HELLO_MAGIC, NULL, 0, &endpoint);
  return_check (rc, "mx_open_endpoint");

  rc = mx_get_endpoint_addr(endpoint, &my_address);
  return_check(rc, "mx_get_endpoint_addr");

  rc = mx_decompose_endpoint_addr(my_address, &nic_id, 
				  &endpoint_id);
  return_check(rc, "mx_decompose_endpoint_addr");

  printf("Receiver nicid 0x%08x%08x, endpoint_id %d\n",
	 MX_U32(nic_id), MX_L32(nic_id), endpoint_id);

  printf("enter first address: ");
  scanf("%s", dest_str);
  rc = mx_hostname_to_nic_id(dest_str, &nic_id);
  return_check(rc, "mx_hostname_to_nic_id");
  printf("first nic_id = 0x%08x%08x\n", MX_U32(nic_id), MX_L32(nic_id));
  mx_connect(endpoint, nic_id, 1, HELLO_MAGIC, MX_INFINITE, &dest[0]);
  
  printf("enter second address: ");
  scanf("%s", dest_str);
  rc = mx_hostname_to_nic_id(dest_str, &nic_id);
  return_check(rc, "mx_hostname_to_nic_id");
  printf("second nic_id = 0x%08x%08x\n", MX_U32(nic_id), MX_L32(nic_id));
  mx_connect(endpoint, nic_id, 1, HELLO_MAGIC, MX_INFINITE, &dest[1]);

  if (sender) {
    seg[0].segment_ptr = "Hello";
    seg[0].segment_length = strlen(seg[0].segment_ptr);
    seg[1].segment_ptr = ", world.\n";
    seg[1].segment_length = strlen(seg[1].segment_ptr) + 1;
    
    rc = mx_ibcast(endpoint, seg, 2, dest, 2, 0,
		   MAKE_MATCH(unmaskable, maskable), NULL, &handle);
    return_check(rc, "mx_ibcast");
  } else {
    
    /* wait for a bit to test unexpected receive path
       (void) mx_wait_all(endpoint, 10*1000, &handle, &stat);
    */
    
    seg[0].segment_ptr = buf;
    seg[0].segment_length = 1;
    seg[1].segment_ptr = buf + 1;
    seg[1].segment_length = sizeof (buf) - 1;

    rc = mx_ibcast(endpoint, seg, 2, dest, 2, 0,
		   MAKE_MATCH(unmaskable, maskable), NULL, &handle);
    return_check(rc, "mx_ibcast");
  }

  if (sender) {
    
    /* wait for operation to complete */
    rc = mx_wait(endpoint, &handle, 30*1000, &stat, &result);
    return_check(rc, "mx_wait");

    printf("mx_wait, handle = %p, return = %s\n", handle, mx_strerror(rc));
    
  }
  else {
    
    /* wait for operation to complete */
    rc = mx_wait(endpoint, &handle, 30*1000, &stat, &result);
    return_check(rc, "mx_wait");

    printf("mx_wait, handle = %p, return = %s\n", handle, mx_strerror(rc));

    printf(buf);
    
  }

  mx_close_endpoint(endpoint);
  mx_finalize();
  return 0;
}
